/*
Copyright ＿ 2011, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/

var allTheData = [{symbol:'^DJI', exchange:"", price:0, change:0, changepercent:0, name:"DOW JONES INDUSTRIAL AVERAGE"},
				 {symbol:'^IXIC', exchange:"", price:0, change:0, changepercent:0, name:"NASDAQ COMPOSITE"},
				 {symbol:'AAPL',  exchange:"", price:0, change:0, changepercent:0, name:"Apple Inc."},
				 {symbol:'EBAY',  exchange:"", price:0, change:0, changepercent:0, name:"eBay"},
				 {symbol:'GOOG',  exchange:"", price:0, change:0, changepercent:0, name:"Google Inc."},
				 {symbol:'AMZN',  exchange:"", price:0, change:0, changepercent:0, name:"Amazon.com, Inc."}
				];
var symbolData = new Array();
var allFetchedQuotes = new Array();
var editRolloverImg = null;
var carouselHidden = false;

var widgetWidth = 226;
var widgetMinHeight = 201;
var carouselPanelHeight = 116;

var currentSelection = null;
var selectedRow = null; //on the backside list
var lastSelectedRow = null;

var anythingChangedOnBackside = false;

var currentChartMode = '6m';
var currentValueFormat = 'percent';
var isShowingFront = true;
var allMarketsOpen = true;
var timer = null;
var updateTimer = 60000; // updates every minute
var crossfadeTimer = null;
var removeButton = null;
var lastDownloadDate = null;
var XMLErrorOnLastDataRequest = false;

var kChartCanvasWidth = 170;
var kChartCanvasHeight = 78;
var kOffsetBtCanvasAndXAxes = 7;

var deleteKeyLock = false;
var gLastRemovedSymbol = {};

var currentChartSelect = null;
var lastChartRequest = null;
var lastNewsRequest = null;

var gChartObj = null;
var gFinalPointEndPosition = 1.0;

var DAY_CHART_MAX_LABEL_ADJUST = .75;
var MIN_CHART_STEP_STANDARD = 2;
var MAX_PRICE_DELTA_FOR_FORCED_CENTS_DISPLAY = 2;
var MAX_GUARANTEED_CENTS_DISPLAY_PRICE = 100;
var WEEK_CHART_UNFINISHED_MINUTES = 20;


function $(id, inOptAncestor) {
	d = inOptAncestor || document;
	return d.getElementById(id);
}

function getLocalizedString (key) {
	try {
		var ret = localizedStrings[key];
		if (ret === undefined) {
			ret = key;
		}
		return ret;
	} catch (ex) {}
	return key;
}

function hidpiPath (inPath)
{
	if ( window.devicePixelRatio > 1 )
		return inPath.replace(".png", "@2x.png");
	else
		return inPath;
}

function getPrettySymbol (symbol) {
	// Explicit overrides
	if (symbol == "^DJI")  return "DOW J";
	if (symbol == "^IXIC") return "NASDAQ";
	if (symbol == "^GSPC") return "S&P 500";
	
	return symbol;
}

function updateStatusText() {
	var dateDiff = null;
	var startFade = false;
	stopDelayedTextCrossFade();
	
	if (lastDownloadDate != null) {
		// Update our "last updated" timer
		var curDate = new Date();
		dateDiff = curDate.getTime() - lastDownloadDate.getTime();
		dateDiff = Math.round(dateDiff / 1000); // to seconds
				
		if (allMarketsOpen) {
			$('quoteUpdateDiv').innerText = getLocalizedString("Quotes delayed by 20 minutes");
		} else { // markets closed
			startFade = true;
			$('quoteUpdateDiv').innerText = getLocalizedString("Quotes last updated at %@").replace("%@", lastDownloadDate.toLocaleTimeString("short"));
			$('messageDiv').innerText = getLocalizedString("Markets closed");
			// $('messageDiv').innerText = getLocalizedString("Server quotes updated hourly");
		}
	}

	if(XMLErrorOnLastDataRequest && lastDownloadDate && dateDiff > 300) { //dont show error if quotes < 5 min old
		startFade = true;
		$('quoteUpdateDiv').innerText = getLocalizedString("Quotes last updated at %@").replace("%@", lastDownloadDate.toLocaleTimeString("short"));
		$('messageDiv').innerText = getLocalizedString("No response from server");
	}

	if(startFade) {
		startCrossFade(4000);
	}
}

var gCrossFadingTextOK = false; 
function startCrossFade (delay) {
	if(!delay) delay = 0;
	gCrossFadingTextOK = true;
	crossfadeTimer = setTimeout(performCrossFade, delay);
}

function performCrossFade () {	

	var delayedDivOpacity = $('quoteUpdateDiv').style.opacity; 
	var delayed1Showing = (!delayedDivOpacity || delayedDivOpacity == 1);

	if(gCrossFadingTextOK) {
		$('quoteUpdateDiv').style.opacity = delayed1Showing ? 0 : 1;
		$('messageDiv').style.opacity = delayed1Showing ? 1 : 0;
		crossfadeTimer = setTimeout(crossfadeFinished, 2000);
	}
}

function crossfadeFinished () {
	if(gCrossFadingTextOK)
		crossfadeTimer = setTimeout(performCrossFade, 10000);
}

function stopDelayedTextCrossFade () {
	gCrossFadingTextOK = false;
	clearTimeout(crossfadeTimer);
	crossfadeTimer = null;
	$('quoteUpdateDiv').style.opacity = 1;
	$('messageDiv').style.opacity = 0;
}

function news_callback(object){
	if (!object.error) {
		clearNews(); // clear news articles
		try {
			populateNews(object.news);
		} catch (ex) {
			// dont let one exception lose all the data
			if (console) console.error(ex.name + ". " + ex.message);
			XMLErrorOnLastDataRequest = true;
		}
	} else {
		XMLErrorOnLastDataRequest = true;
		if (console) console.error("Stocks Widget: XMLHttpRequest Failed (" + object.errorString + ")");
	}
	
}

function xml_callback(object) {
	if (!object.error) {
		clearStockInfo(); // clear details panel
		allFetchedQuotes = [];
		var c = object.quotes.length;
		for (var i = 0; i < c; ++i) {
			try {
				var quote = object.quotes[i];
				symbolData[i] = quote;
				allFetchedQuotes[i] = quote;
				
				if ( quote.symbol == "unknown" )
				{
					// skip if we don't have info
					continue;
				}
				else
				{
					var elRow = $(quote.symbol+"_row");
					var elLastTrade = $(quote.symbol+"_lastTrade");
					var elChange = $(quote.symbol+"_change");
					var elPercent = $(quote.symbol+"_percent");
					var elMktCap = $(quote.symbol+"_mktcap");
					var button = $(quote.symbol+"_button");
					var elOperator = button.getElementsByClassName('op')[0];
					
					var price = formatAmount(quote.price);
					var change = formatAmount(quote.change);
					var changepercent = formatAmount(quote.changepercent)+'%';
					var mktcap = formatLargeAmount(quote.marketcap);
					if (!mktcap) {
						mktcap = '&#8212;'; // em dash
						elMktCap.className = '_mktcap _na';
					}
					
					if (change < 0 || changepercent < 0) {
						button.className = 'loss';
						elOperator.innerHTML = '&minus;';
						elOperator.setAttribute('aria-label', getLocalizedString('Up')+' ');
						change = change.substr(1);
						changepercent = changepercent.substr(1);
					} else {
						// percentages can comeback -0.00.  strip the negative in this case.
						if (changepercent[0] == "-"){
							changepercent = changepercent.substr(1);
						}
						button.className = 'gain';
						elOperator.innerHTML = '+';
						elOperator.setAttribute('aria-label', getLocalizedString('Down')+' ');
					}
					
					elLastTrade.innerHTML = price;
					elChange.innerHTML = change;
					elPercent.innerHTML = changepercent;
					elMktCap.innerHTML = mktcap;
					
					// if stock is selected populate details panel and news articles
					if (currentSelection == elRow) {
						populateStockInfo(quote);
					}
					
					// Store last downloaded time
					lastDownloadDate = new Date();
				}
				
			} catch (ex) {
				// dont let one exception lose all the data
				if (console) console.error(ex.name + ". " + ex.message);
				XMLErrorOnLastDataRequest = true;
			}
		}
		
		if (object.open != allMarketsOpen) {
			allMarketsOpen = object.open;
		}
		
		
	} else {
		XMLErrorOnLastDataRequest = true;
		if (console) console.error("Stocks Widget: XMLHttpRequest Failed (" + object.errorString + ")");
	}
	
	// Regardless of what happened above
	updateStatusText(); // "Quotes just updated" or "Last updated xx minutes ago"
}

var notDigitPeriodOrMinus_regex = /[^\d\.\-]/g;
function formatAmount(string) {
	if (!string) return '';
	
	//strip out extra characters (6076938)
	var formattedString = string.replace(notDigitPeriodOrMinus_regex, "");
	var periodIndex = formattedString.indexOf(".");

	// Some currencies don't show precision (6076945), but round the occasional errata with > 2 decimal places
	if(periodIndex != -1 && (formattedString.length - periodIndex > 3)) {
		var roundedNum = (new Number(formattedString)).toFixed(2);
		if(roundedNum) {
			formattedString = roundedNum.toString();
		} else {
			formattedString = formattedString.substring(0, periodIndex + 2);
		}
	}
	return formattedString;
}
// function formatLargeAmount(string){
// 	if (!string || string == 'N/A' || parseFloat(string)==0 ) return '';
// 	var unit = string.split('').pop(); // save 'B' for billions, 'M' for millions, etc.
// 	var formattedString = formatAmount(string);
// 	var num = new Number(formattedString);
// 	if (num) { // otherwise NaN; just trust the formattedString
// 		formattedString = num.toFixed(2);
// 		if (formattedString.length > 5) formattedString = num.toFixed(1); // round to a single decimal if the mkt cap is over 99.99B
// 	}
// 	formattedString += unit; // add back the 'B' for billions, etc.
// 	return formattedString;
// }
function formatLargeAmount(amount) {
	if (amount == null || isNaN(amount)) {
	  return 'N/A';
	}
  
	var num = parseFloat(amount);
  
	var suffixes = ['', 'K', 'M', 'B', 'T', 'Q'];
  
	var i = 0;
	while (num >= 1000 && i < suffixes.length - 1) {
	  num /= 1000;
	  i++;
	}
  
	var decimalPlaces = (i > 0) ? 3 : 0;
	if (num % 1 === 0) {
	  decimalPlaces = 0;
	}
  
	return num.toFixed(decimalPlaces) + suffixes[i];
}
function formatPrice(string){
	if (!string) return '';
	var num = parseFloat(string);
	if (isNaN(num)) {
		return string;
	}
	return num.toFixed(2);
}
function formatVolume(string){
	if (!string) return '';
	var num = parseInt(string)/1000000;
	num = num.toFixed(3) + 'M'; // millions not localized; probably okay since billions comes back preformatted 'B' 
	return num;
}
function formatYield(string){
	if (!string) return '';
	var formattedString = formatAmount(string);
	var num = new Number(formattedString).toFixed(2);
	if (!num || num === '0.00') return '';
	return num;
}

function createRow(object) {
	var theSymbol = object.symbol;
	var theName = object.name;
	var valueFormat = getValueFormat();
	var prettySymbol = getPrettySymbol(theSymbol);
	
	var row = document.createElement('div');
	row.setAttribute('role','row');
	row.setAttribute('title',theName);
	row.setAttribute("onclick", "clickonrow(event, this);");
	row.setAttribute("ondblclick", "clickedOnSymbol(this.getAttribute('tag'), this.getAttribute('stock_exchange'));");
	row.setAttribute("tag", theSymbol);
	row.id = theSymbol + "_row";
	row.setAttribute("stock_exchange", object.exchange);
	
	{ // cells
		
		// symbol cell (column 1)
		var cell = document.createElement ('span');
		cell.setAttribute('class', 'symbol');
		cell.setAttribute('role','rowheader');
		cell.setAttribute('tabindex', '0');
		cell.setAttribute('title',theName);
		cell.appendChild(document.createTextNode(prettySymbol));
		row.appendChild(cell);
	
		// value cell (column 2)
		cell = document.createElement('span');
		cell.setAttribute("class", "value");
		cell.setAttribute('role','gridcell');
		cell.setAttribute("id", theSymbol + "_lastTrade");
		cell.innerHTML = '&nbsp;';
		row.appendChild(cell);
	
		// change button cell (column 3)
		cell = document.createElement('span');
		cell.setAttribute('role','gridcell');
	
		{
			// gain/loss button in each row
			var button = document.createElement('span');
			button.setAttribute("class", "gain");
			button.setAttribute("role", "button");
			button.setAttribute("id", theSymbol + "_button");
			button.setAttribute("onclick", "showAsPercentChanged(event);");
		
			{
				var inner, s;
				
				// operator +/-
				inner = document.createElement('em');
				s = '';
				inner.className = 'op';
				inner.setAttribute('role', 'text');
				inner.innerHTML = '&nbsp;';
				button.appendChild(inner);
			
				// dollar change
				s = '_change';
				inner = document.createElement('span');
				inner.className = s;
				inner.id = theSymbol + s;
				button.appendChild(inner);
				inner.innerHTML = '&nbsp;';
			
				// percent change
				s = '_percent';
				inner = document.createElement('span');
				inner.className = s;
				inner.id = theSymbol + s;
				button.appendChild(inner);
				inner.innerHTML = '&nbsp;';
			
				// market cap
				s = '_mktcap';
				inner = document.createElement('span');
				inner.className = s;
				inner.id = theSymbol + s;
				button.appendChild(inner);
				inner.innerHTML = '&nbsp;';
			
			}
	
		}
	
		cell.appendChild(button);
		
	} // end cells
	
	row.appendChild(cell);
	return row;
}

// show value, percent, or market cap
var valueFormat = 'percent';
var valuePrefFetched = false;

function getValueFormat(forceFetch) {
	if (forceFetch || !valuePrefFetched) {
		if (window.widget) {
			var pref = null;
			var pref = getPreferenceForKey("valueformat", true);
			
			valueFormat = pref;
			if (valueFormat != 'change' && valueFormat != 'mktcap') {
				valueFormat = 'percent'; // default
				setPreferenceForKey(valueFormat, "valueformat");
			}
			
		}
		valuePrefFetched = true;
	}
	return valueFormat;
}

function nextValueFormat(){
	var s = getValueFormat();
	switch(s){ // todo: if this list gets longer, it'd be better to pop an array
		case 'percent': s = 'change';  break;
		case 'change' : s = 'mktcap';  break;
		case 'mktcap' : s = 'percent'; break;
		default: s = 'percent';
	}
	// save the pref
	setValueFormat(s);
	return s;
}

function setValueFormat(s) {
	valueFormat = s;
	setPreferenceForKey(s, "valueformat");
}

function showBackside(event) {
	var front = $("front");
	var back = $("back");

	anythingChangedOnBackside = false;

	if (window.widget) {
		window.resizeTo(widgetWidth, calculateWidgetHeight() - 7);
		widget.prepareForTransition("ToBack");
	}
	
	back.style.display="block";
	front.style.display="none";
	isShowingFront = false;
	
	if (window.widget) {
		setTimeout ('widget.performTransition();', 0);
	}
	
	if (timer != null) {
		clearInterval (timer);
		timer = null;
	}
	
	document.removeEventListener("keypress", keyPressed, true);
	selectAllInSymbolTextField();
	
	event.stopPropagation();
	event.preventDefault();
}

function showFrontside () {
	var front = $("front");
	var back = $("back");

	isShowingFront = true;

	if (anythingChangedOnBackside) {
		if (window.widget) {
			window.resizeTo(widgetWidth, calculateWidgetHeight());
		}
		setupMainTable(false);
	}
	
	widget.prepareForTransition("ToFront");
	
	front.style.display="block";
	back.style.display="none";
	
	if (window.widget){
		setTimeout ('widget.performTransition();', 0);
	}

	var lastSelected = null;
			
	if (currentSelection != null) {
		lastSelected = currentSelection.getAttribute("tag");
	}
		
				
	if (lastSelected != null) {
		var c = allTheData.length;
		var found = false;
		for (var i = 0; i < c; ++i) {
			if (allTheData[i].symbol == lastSelected) {
				found = true;
				break;
			}
		}
			
		if (!found) {
			// the item we have selected is gone. select the first one
			clickonrowimp($('tbody').firstChild);
		}
	}
		
	if (anythingChangedOnBackside) {
		if (window.widget) {
			// save off the new prefs
			var pref = createAllDataJSString();
			setPreferenceForKey(pref, "symbols")
		}
	}
	onshow();

	//	dont remember last deleted stock, do remember last selected row
	gLastRemovedSymbol = {};
	lastSelectedRow = selectedRow;

	document.removeEventListener("keypress", backsideKeyPressed, true);
	document.removeEventListener("keyup", backsideKeyUp, true);	
	document.addEventListener("keypress", keyPressed, true);
}

function generateSymbolString (object) {
	return object.symbol;
}

function generateSymbolStringFromStrings (symbol, exchange) {
	return symbol;
}

function getStockData() {
	var c = allTheData.length;
	if (c > 0) {
		var symbols = [];
		for (var i = 0; i < c; ++i) {
			symbols.push(generateSymbolString(allTheData[i]));
		}
	
		XMLErrorOnLastDataRequest = false;
		fetchStockData(xml_callback, symbols);
		
		//get news if stock is selected
		if (currentSelection != null) {
			if (lastNewsRequest != null) {
				lastNewsRequest.abort();
			}
			var tag = currentSelection.getAttribute("tag");
			var exchange = currentSelection.getAttribute("stock_exchange");
			lastNewsRequest = fetchNewsData(news_callback, [generateSymbolStringFromStrings(tag, exchange)]);
		}
		
		//get chart if stock is selected, chart mode is day or week view, and markets are open
		if (currentSelection != null && (currentChartMode == '1d' || currentChartMode == '1w') && marketsAreKnownToBeOpen()) {
			if (lastChartRequest != null) {
				lastChartRequest.abort();
			}
			var tag = currentSelection.getAttribute("tag");
			var exchange = currentSelection.getAttribute("stock_exchange");
			lastChartRequest = fetchChartData(generateSymbolStringFromStrings(tag, exchange), currentChartMode, chart_callback);
		}
	}
}

function clearStockInfo(){
	populateStockInfo(false);
}

function populateStockInfo(quote){
	var em = '&#8212;';
	$('details_company').innerHTML = quote.name || getLocalizedString('Loading Details…');
	$('details_open').innerHTML = formatAmount(quote.open) || em;
	$('details_high').innerHTML = formatAmount(quote.high) || em;
	$('details_low').innerHTML = formatAmount(quote.low) || em;
	$('details_volume').innerHTML = formatVolume(quote.volume) || em;
	$('details_peratio').innerHTML = formatAmount(quote.peratio) || em;
	  
	$('details_marketcap').innerHTML = formatLargeAmount(quote.marketcap);

	// todo: Finish once related <rdar://problem/9349031> is complete
	$('details_yearhigh').innerHTML = formatPrice(quote.yearhigh) || em;
	$('details_yearlow').innerHTML = formatPrice(quote.yearlow) || em;
	
	$('details_averagedailyvolume').innerHTML = formatVolume(quote.averagedailyvolume) || em;
	$('details_yield').innerHTML = formatYield(quote.yield) || em;
}

function clearNews(){
	populateNews(false);
}
function populateNews(news){
	var list = $('news_list');
	if (!news) {
		list.innerHTML = '';
		return;
	}
	var divider, link, timestamp, titleAndSource, title, source, months, hours, ampm;
	var str = '';
	for (var i=0, c=news.length; i<c; i++) {
		item = news[i];
		divider = ' (at at '; // reset it each time
		link = item.link;
		date = new Date(parseInt(item.timestamp) * 1000); // timestamp returns seconds since epoch, not milliseconds
		hour = date.getHours();
		ampm = 'AM';
		if (hour == 12) { // 12 PM
			ampm = 'PM';
		} else if (hour>12) { // after noon; e.g., 3 PM
			hour -= 12;
			ampm = 'PM';
		} else if (!hour) { // 0; e.g. 12 AM
			hour = 12;
		}
		minute = date.getMinutes().toString();
		if (minute.length<2) {
			minute = '0' + minute;
		}
		datestring = getLocalizedString('%MM/%DD/%YY at %hh:%mm %AMPM');
		datestring = datestring.replace('%MM', date.getMonth()+1);
		datestring = datestring.replace('%DD', date.getDate());
		datestring = datestring.replace('%YY', date.getFullYear()-2000);
		datestring = datestring.replace('%hh', hour);
		datestring = datestring.replace('%mm', minute);
		datestring = datestring.replace('%AMPM', getLocalizedString(ampm));
		
		titleAndSource = item.title;
		if (titleAndSource.indexOf(divider) == -1) divider = divider.replace('at at', 'at'); // this data is pretty messy
		titleAndSource = titleAndSource.replace(/\)$/,'').split(divider);
		title = titleAndSource[0].replace(/\[[a-zA-Z0-9\$]*\] /g, ''); // clears bracketed junk at beginning of some strings ('[external] ', '[$$] ', etc.); may need some additional tweaking.
		source = titleAndSource[1];
		// str += '<li><a href="' + link + '" onclick="return openLink(this.href);"><span role="text"><strong class="title" title="' + title + '">' + title + '</strong><span class="source" title="' + source + '">' + source + '</span> – <span class="datetime">' + datestring + '</span></span></a></li>';
		str += '<li><a href="' + link + '" onclick="return openLink(this.href);"><span role="text"><strong class="title" title="' + title + '">' + title + '</strong><span class="source" title="' + '">' + '</span><span class="datetime">' + datestring + '</span></span></a></li>';
	}
	list.innerHTML = str;
}


function marketsAreKnownToBeOpen() {
	//confirm allMarketsOpen was set today (there is a last download and the date is today's)
	var currentDate = new Date();
	return (lastDownloadDate == null) || (allMarketsOpen && lastDownloadDate.getDate() == currentDate.getDate());
}

function changeAriaSelection(el, isSelected) {
	if (!el) return;
	var value = isSelected ? 'true' : 'false';
	el.setAttribute('aria-selected', value);
	// selection isn't always recognized on row, so loop through all the cells to select or deselect
	var cells = el.childNodes;
	for (var i=0, c=cells.length; i<c; i++) {
		cells[i].setAttribute('aria-selected', value);
	}
}

function clickonrowimp(row) {
	changeAriaSelection(currentSelection, false);
	currentSelection = row;
	var tag = row ? row.getAttribute('tag') : '';
	var title = getLocalizedString('WidgetDisplayName:') + ' ';
	if (currentSelection && currentSelection.getAttribute) title += currentSelection.getAttribute('title');
	document.title = title; // for VO window chooser
	changeAriaSelection(currentSelection, true);
	getChartForCurrentMode();
}

function setCarouselHidden(bSetHidden) {	
	var carouselDiv = $('carousel');
	var timeNow = (new Date).getTime();
	var multiplier = (event.shiftKey ? 10 : 1); // enable slo-mo
	var startingSize = parseInt(carouselDiv.clientHeight,10);

	resizeAnimation.element = carouselDiv;
	if (resizeAnimation.timer != null) { // it is moving… change to new size
		clearInterval(resizeAnimation.timer);
		resizeAnimation.timer = null;
		resizeAnimation.duration -= (timeNow - resizeAnimation.startTime);
		resizeAnimation.positionFrom = resizeAnimation.positionNow;
	} else {
		resizeAnimation.duration = 250 * multiplier;
		resizeAnimation.positionFrom = startingSize;
	}
	
	if (window.widget && !bSetHidden) {
		window.resizeTo(widgetWidth, calculateWidgetHeight());
	}
	resizeAnimation.positionTo = bSetHidden ? 0 : carouselPanelHeight;
	resizeAnimation.startTime = timeNow - 13; // set it back one frame.
	resizeAnimation.onfinished = bSetHidden ? animFinished : null;
	
	resizeAnimation.element.style.height = startingSize;
	resizeAnimation.timer = setInterval ("animate();", 13);
	animate();
	
	carouselHidden = bSetHidden;
	$('front').className = carouselHidden ? '' : 'show_carousel';
	
}

function clickonrow(event, row) {
	var oldSelection = currentSelection;
	
	if (currentSelection != null && row == currentSelection) {
		changeAriaSelection(currentSelection, false);
		currentSelection = null;
		setPreferenceForKey("!!NONE!!", "selection");
		setCarouselHidden(true); // hide bottom carousel panels
		if (lastChartRequest != null) {
			lastChartRequest.abort();
			lastChartRequest = null;
		}
	} else {
		clickonrowimp(row);
		
		if (oldSelection != currentSelection) {
			//write out the selection
			setPreferenceForKey(row.getAttribute("tag"), "selection");
		}
		
		if (oldSelection == null) {
			setCarouselHidden(false); // show bottom carousel panels
		}
	}
}


//You can pass (null, null) to deselect any row
function clickonbackrow(event, row) {
	if (allTheData.length > 1 && removeButton) {
		removeButton.setEnabled(true);
	}

	if (selectedRow != row) {
		
		if (selectedRow != null) {
			selectedRow.setAttribute('class', 'row');
			selectedRow.setAttribute('aria-selected', 'false');
			selectedRow.setAttribute('tabindex','-1');
		}
		selectedRow = row;
		
		if(row) {
			row.setAttribute("class", "row select");
			row.setAttribute('aria-selected', 'true');
			row.setAttribute('tabindex','0');
			row.focus(); // focus the newly selected row
		}
	}

	if (event) {
		event.stopPropagation();
		event.preventDefault();
	}
}

function showAsPercentChanged (event) {
	clickonchange(event);
	event.stopPropagation();
	event.preventDefault();
}

function clickonchange (event) {
	event.stopPropagation();
	// cycle the preference
	updateValueFormatUI(nextValueFormat());
}

function updateValueFormatUI(valueFormat) {
	if (!valueFormat) valueFormat = getValueFormat(true);
	var tbody = $('tbody');
	tbody.className = 'show_' + valueFormat;
}

function clickedOnSymbol (symbol, exchange) {
	if (window.widget) {
		var url = 'http://api.apple.go.yahoo.com/appledwf/q?s=' + symbol;
		
		for(index in symbolData){
			if(symbolData[index].symbol == symbol && symbolData[index].link != null){
				url = symbolData[index].link;
			}
		}
		widget.openURL(url);
	}
}

function setupFetchTimer () {
	timer = setInterval('getStockData();', updateTimer);
}

function onshow () {
	if (timer == null) {
		// reload we were just shown
		$('quoteUpdateDiv').innerText = getLocalizedString('Retrieving Data…');
		getStockData();
		timer = setInterval('getStockData();', updateTimer);
	} else {
		updateStatusText(); // at least update them on our status
	}
    updateValueFormatUI();
}

function onhide () {
	stopDelayedTextCrossFade();
	if (timer != null) {
		// we were hidden clear the timer.
		clearInterval(timer);
		timer = null;
	}
}

document.addEventListener("keypress", keyPressed, true);


function keyPressed(e) {
	
	var handled = true;
	var selection = currentSelection;
	
	if (selection != null) {
		switch (e.charCode) {
			
			case 63234: // left
				changeChartMode(e, 'prev');
				return;
			
			case 63232: // up
				currentSelection.firstChild.setAttribute('tabindex','-1');
				var newSelection = selection.previousSibling;
				if (newSelection != null) selection = newSelection;
				selection.firstChild.setAttribute('tabindex','0');
				selection.firstChild.focus(); // focus first cell (stock symbol) in the newly selected row
				break;
			
			case 63235: // right
				changeChartMode(e, 'next');
				return;
			
			case 63233: // down
				currentSelection.firstChild.setAttribute('tabindex','-1');
				var newSelection = selection.nextSibling;
				if (newSelection != null) selection = newSelection;
				selection.firstChild.setAttribute('tabindex','0');
				selection.firstChild.focus(); // focus first cell (stock symbol) in the newly selected row
				break;
				
			default:
				handled = false;
				break;
		}
		
		if (handled) {
			if (currentSelection != selection) clickonrow(e, selection);
			e.stopPropagation();
			e.preventDefault();
		}	
	}
}

function setupMainTable(addSymbolsToBackside) {
	var	c = allTheData.length;
	var container = $('tbody');
	
	removeAllChildren(container);

	if (addSymbolsToBackside) {
		var innerList = $('inner-list');
		innerList.innerHTML = "";
	}

	for (var i=0; i<c; ++i)
	{
		var data = allTheData[i];
		var row = createRow(data);
		
		container.appendChild(row);
		
		if (addSymbolsToBackside)
		{
			addsymbol(getPrettySymbol(data.symbol), data.name, (i==0 ? true : false) ); // 3rd arg (isSelected) defaults to first item only
		}
	}
}

function loadPreferences() {
	if (window.widget) {
		try {
			selectedSymbol = getPreferenceForKey("selection", false);
			var symbols = getPreferenceForKey("symbols", true);
			var newAllData = new Array;

			currentChartMode = getPreferenceForKey("chartmode", false);
			if (currentChartMode == null) currentChartMode='6m';
			
			currentValueFormat = getPreferenceForKey("valueformat", false);
			if (currentValueFormat == null) currentValueFormat='percent';

			symbols = eval(symbols);
			if (!symbols || !symbols.length) return;

			if (symbols.length == 0) {
				allTheData = new Array; // nothing to see move along
			} else {
				for (var i = 0; i < symbols.length; ++i) {
					var data = symbols[i];
					
					//We no longer use default values of INDU/COMPX for US indices. Replace them.
					var stockSymbol = (data.symbol == "INDU") ? "^DJI" : data.symbol;
						stockSymbol = (data.symbol == "COMPX") ? "^IXIC" : stockSymbol;
					
					var exchange = data.exchange === undefined ? '' : data.exchange;
					newAllData[newAllData.length] = {symbol:stockSymbol, exchange:exchange, name:data.name, price:0, change:0, changepercent:0};
				}
				allTheData = newAllData;
			}
		
		} catch(ex) {
			if (console) console.error(ex.name + ". " + ex.message);
		}
	} else {
		selectedSymbol = null;
	}
}

function setupUI() {
	// add all of our stocks to the widget
	setupMainTable(true);
	setupChartController(currentChartMode);
	updateValueFormatUI(currentValueFormat);

	var header = $('tbody');
	currentSelection = header.firstChild;
	if (selectedSymbol != null) {
		if (selectedSymbol == '!!NONE!!') {
			currentSelection = null;
			carouselHidden = true;
			$('carousel').style.height = "0";
		} else {
			for (var child = header.firstChild; child != null; child = child.nextSibling) {
				if (child.getAttribute("tag") == selectedSymbol) {
					// no need to do anything if the first item is the one selected.
					if (currentSelection != child) {
						clickonrowimp(child);
					}
					break;
				}
			}
		}
	} else {
		// try to select apple.
		for (var child = header.firstChild; child != null; child = child.nextSibling) {
			if (child.getAttribute("tag") == 'AAPL') {
				// no need to do anything if the first item is the one selected.
				if (currentSelection != child) {
					clickonrowimp(child);
				}
				break;
			}
		}
	}

	if (!carouselHidden) {
		getChartForCurrentMode();
	}
	
	if (window.widget) {
		window.resizeTo(widgetWidth, calculateWidgetHeight());
	}
	
	// for VO Window Chooser
	var title = getLocalizedString('WidgetDisplayName:');
	if (currentSelection) title += ' ' + currentSelection.getAttribute('title');
	document.title = title;
}

function setupWidget() {
	var selectedSymbol = null;
	
	panels = [$('panel_chart'), $('panel_details'), $('panel_news')];
	
	if (window.devicePixelRatio > 1 )
	{
		$("logo").src = "img/Logo_yahoofinance@2x.png";
	}
	
	if ( (navigator.language === "ar") || (navigator.language === "he") )
	{
		$("panel_details").dir = "rtl";
	}

	loadPreferences();
	setupUI();
	
	// addtl loc init
    /*
	for (var item in localizedControls) {
		var el = $(item);
		var label = localizedControls[item];
		if (!el) continue;
		var tag = el.tagName.toLowerCase();
		if (tag == 'th') {
			el.innerHTML = '<span>' + label + '</span>';
		} else if (tag == 'img') {
			el.setAttribute('alt', label);
		} else {
			el.setAttribute('aria-label', label);
		}
	}
	*/
    
	// front-side labels
	$('th_symbol').innerHTML = getLocalizedString('col_symbol');
	$('th_value').innerHTML = getLocalizedString('col_value');
	$('th_change').innerHTML = getLocalizedString('col_change');
	
	
	// abbreviated visual labels on the Details panel
	var shortLabels = [
		'short_open',
		'short_high',
		'short_low',
		'short_vol',
		'short_peratio',
		'short_mktcap',
		'short_52wHigh',
		'short_52wLow',
		'short_avgvol',
		'short_yield'
	];
	for (var i in shortLabels) {
		var el = $(shortLabels[i].replace('short_', 'label_'));
		if (!el) continue;
		el.setAttribute('role', 'text');
		el.setAttribute('aria-label', getLocalizedString(shortLabels[i]));
		el.innerHTML = getLocalizedString(shortLabels[i]);
	}
	
	// unabbreviated labels for VO on the Details panel
	var longLabels = [
		'label_vol', 
		'label_peratio',
		'label_mktcap',
		'label_52wHigh',
		'label_52wLow', 
		'label_avgvol'
	];
	for (var i in longLabels) {
		var el = $(longLabels[i]);
		if (!el) continue;
		el.setAttribute('aria-label', getLocalizedString(longLabels[i]));
	}
	
	// backside strings
	$('quoteslabel').innerText = getLocalizedString('Quotes:');
	
	// Remove button
	removeButton = new AppleGlassButton($('remove'), getLocalizedString('Remove'), removeButtonClicked);
	removeButton.setEnabled(false);
	
	// Done button
	var doneButton = new AppleGlassButton($('done'), getLocalizedString('Done'), showFrontside);
	doneButton.textElement.style.textAlign = "center";
	doneButton.textElement.style.width = "47px";
	onshow();
	
}

function onsync() {
	loadPreferences();
	setupUI();
	onshow();
}

// add the onhide and onshow callbacks
if (window.widget) {
	widget.onhide = onhide;
	widget.onshow = onshow;
	widget.onremove = onremove;
	widget.onsync = onsync;
}

function backsideKeyPressed(event) {
	var newSelection = null;
	switch (event.keyCode) {
		
		//case 63234: // left
		
		case 63232: // up
			if (selectedRow != null)
				newSelection = selectedRow.previousSibling;
			if (newSelection == null)
				newSelection = $('inner-list').firstChild;
			clickonbackrow(null, newSelection);
			break;
			
		//case 63235: // right
			
		case 63233: // down
			if (selectedRow != null)
				newSelection = selectedRow.nextSibling;
			if (newSelection == null)
				newSelection = $('inner-list').lastChild;
			clickonbackrow(null, newSelection);
			break;
		//case 9: // tab
		// no longer doing this b/c it was keeping FKA from working (5 Apr 2010)
		//	lastSelectedRow = selectedRow; //remember selected row and focus on textfield
		//	selectAllInSymbolTextField();
		//	break;
		case 8: // delete
			if(!deleteKeyLock && allTheData.length > 1) //delete only once if delete is held down, dont delete last symbol
			{
				deleteKeyLock = true;
				removeButtonClicked();
			}
			break;
		case 122: //z key, check for undo
			if(event.metaKey)
				undoLastRemoval();
			break;
	}

	if (event) {
		event.stopPropagation();
		event.preventDefault();
	}
}

function backsideKeyUp(event) {
	deleteKeyLock = false;
}

function symbolFocus(event) {
	document.removeEventListener("keypress", backsideKeyPressed, true);
	document.removeEventListener("keyup", backsideKeyUp, true);
}

function symbolBlur(event) {
	document.addEventListener("keypress", backsideKeyPressed, true);
	document.addEventListener("keyup", backsideKeyUp, true);
}

var validateTimerData = null;
var lastValidEntry = null;
var addButtonClicked = false;

function symbolChanged (event) {
	var symbol = $('symbolinput').value;
		
	if (symbol != null && symbol.length > 0 && addButtonClicked) {
		var request = validateSymbol (validateSymbolCallback, symbol.toUpperCase());
		
		cancelValidateTimer();
		lastValidEntry = null;

		var validate = $('validate');
		validate.innerText = getLocalizedString('Validating symbol');
		validate.style.display = "block";
		
		validateTimerData = {timer:setInterval('validateTimer();', 500), pos:0, request:request};
	}
}

function symbolTyping (event) {
	// if we are typing in the input then we cannnot have just clicked the add button
	addButtonClicked = false;
	lastValidEntry = null;
}

function symbolKeyPress (event) {
	switch (event.keyCode) {
		case 13: // return
		case 3:  // enter
			addButtonClicked = true;
			break;
		//case 9: // tab
		// no longer doing this b/c it was keeping FKA from working (5 Apr 2010)
		//	// focus the selected row in the list
		//	var row = lastSelectedRow ? lastSelectedRow : $('inner-list').firstChild;
		//	clickonbackrow(null, row);
		//	break;
	}
	
	if (addButtonClicked) {
		if (lastValidEntry != null) {
			addOrSelectItem ();
		} else {
			symbolChanged();
		}
	}
}

function cancelValidateTimer () {
	if (validateTimerData != null) {
		validateTimerData.request.abort();
		clearInterval(validateTimerData.timer);
		validateTimerData = null;
		$('validate').style.display="none";
	}
}

function validateTimer () {
	var validate = $('validate');
	
	// position goes 0 -> 3 and then resets
	validateTimerData.pos++;
	
	if (validateTimerData.pos > 3) {
		validateTimerData.pos = 0;
	}
	
	var text = getLocalizedString('Validating symbol');
	for (var i = 0; i < validateTimerData.pos; ++i)
		text+= '.';
	
	validate.innerText = text;
}

function validateSymbolCallback (object) {
	var menu = null;
	var inputChanged = false;
	
	cancelValidateTimer();
	
	if (isShowingFront) return;
	
	if (window.widget) menu = widget.createMenu();

	if (object.error) {
		if (menu != null){
			menu.addMenuItem (getLocalizedString("Failed to validate symbol"));
			menu.setMenuItemEnabledAtIndex (0, false);
		}
		if (console) console.error('Validating symbol failed, error=' + object.errorString);
	} else if (object.symbols.length < 1) {
		if (menu != null) {
			menu.addMenuItem (getLocalizedString("No results found"));
			menu.setMenuItemEnabledAtIndex (0, false);	
		}
	} else {
		if (menu == null || object.symbols.length == 1) { // there is only one, just put it in
			menu = null;
			
			lastValidEntry = object.symbols[0];
			$('symbolinput').value = lastValidEntry.symbol;
			inputChanged = true;
		} else {
			if (menu != null) {
				var c = object.symbols.length;
				var a = object.symbols;
				var maxLength = 0;
							
				var lastExchange = a[0].exchange;
				var lastIndex = 0;
				for (var i = 0; i < c; ++i) {
					var str = a[i].symbol;
					var name = a[i].name;
					var exchange = a[i].exchange;
					
					if (name != null || exchange != null) {
						str += " - ";
					
						if (name != null) str += name;
						
						if (exchange != null) {
							if (name != null) str += " (";
							str += exchange;
							if (name != null) str += ")";
						}
					}
					
					if (exchange != null && exchange != lastExchange) {
						menu.addSeparatorMenuItem();
						lastIndex++;
						lastExchange = exchange;
					}
					menu.addMenuItem (str);
					menu.setMenuItemTagAtIndex (lastIndex, i+1); // switch to one based
					lastIndex++;
				}
			}
		}
	}
	
	if (menu != null) {
		var selectedItem = menu.popup (15, 43);
		
		if (selectedItem >= 0) {
			var i = menu.getMenuItemTagAtIndex(selectedItem) - 1;
			lastValidEntry = object.symbols[i];
			$('symbolinput').value = lastValidEntry.symbol;
			inputChanged = true;
		}	
	}
	
	if (addButtonClicked && inputChanged) {
		addOrSelectItem ();	
	}
	
	addButtonClicked = false;
}

function symbolAlreadyInSet(symbol) {
	for (var i = 0; i < allTheData.length; ++i){
		if(allTheData[i].symbol == symbol.toUpperCase()) {
			return i;
		}
	}
	return -1;
}

function addOrSelectItem () {
	var index = symbolAlreadyInSet(lastValidEntry.symbol);
	if (index < 0) {
		// make sure we have the correct number of items
		// if (allTheData.length < 20) {
		// 	var row = addsymbol(getPrettySymbol(lastValidEntry.symbol), lastValidEntry.name);
		
		// 	allTheData[allTheData.length] = {symbol: lastValidEntry.symbol, exchange:lastValidEntry.exchange, name:lastValidEntry.name, price:0, change:0, changepercent:0};
		// 	anythingChangedOnBackside = true;
		// }
		var row = addsymbol(getPrettySymbol(lastValidEntry.symbol), lastValidEntry.name);

		allTheData[allTheData.length] = {symbol: lastValidEntry.symbol, exchange:lastValidEntry.exchange, name:lastValidEntry.name, price:0, change:0, changepercent:0};
		anythingChangedOnBackside = true;
	} else {
		// select the item that is already there.
		var row = $('inner-list').firstChild;
		for (var i = 0; i < index; ++i) {
			row = row.nextSibling;
		}
			
		if (row != null) {// just to be safe, should never happen
			$("symbolinput").blur();
			clickonbackrow(null, row);
		}
	}

	addButtonClicked = false;
}

function addbuttonclicked (event){
	addButtonClicked = true;
	if (lastValidEntry == null) {
		symbolChanged();
	} else {
		addOrSelectItem();
	}
}

var mouseDownInButton = false;
function addButtonMouseDown (event) {
	var button = $('addbutton');
	
	button.src = hidpiPath('img/addbuttondown.png');

	document.addEventListener("mousemove", addButtonMouseMove, true);
	document.addEventListener("mouseup", addButtonMouseUp, true);
	button.addEventListener("mouseover", addButtonMouseOver, true);
	button.addEventListener("mouseout", addButtonMouseOut, true);	
	
	mouseDownInButton = true;
	
	event.stopPropagation();
	event.preventDefault();
}

function addButtonMouseMove (event) {
	event.stopPropagation();
	event.preventDefault();
}

function addButtonMouseOver (event) {
	mouseDownInButton = true;
	$('addbutton').src = hidpiPath('img/addbuttondown.png');
	event.stopPropagation();
	event.preventDefault();
}

function addButtonMouseOut (event) {
	$('addbutton').src = hidpiPath('img/addbutton.png');
	mouseDownInButton = false;
	event.stopPropagation();
	event.preventDefault();
}

function addButtonMouseUp (event) {
	var button = $('addbutton');

	document.removeEventListener("mousemove", addButtonMouseMove, true);
	document.removeEventListener("mouseup", addButtonMouseUp, true);	
	button.removeEventListener("mouseover", addButtonMouseOver, true);
	button.removeEventListener("mouseout", addButtonMouseOut, true);

	button.src = hidpiPath('img/addbutton.png');
	if (mouseDownInButton) {
		addbuttonclicked(event);
	}

	event.stopPropagation();
	event.preventDefault();
}

function findIndexOfChild (child) {
	var node = child.parentNode;
	
	var i = 0;
	
	for (node = node.firstChild; node != null; node = node.nextSibling, ++i) {
		if (node == child) return i;
	}
	
	return -1;
}

function removeAllChildren (parent) {
	while (parent.hasChildNodes()){
		parent.removeChild(parent.firstChild);
	}
}

function removeButtonClicked () {
	if (selectedRow != null) {
		var index = findIndexOfChild (selectedRow);
		var parentNode = selectedRow.parentNode;
		
		if (symbolData[index]) {
			gLastRemovedSymbol["symbolData"] = symbolData[index];
		}
		
		gLastRemovedSymbol["allTheData"] = allTheData[index];
		gLastRemovedSymbol["index"] = index;
		gLastRemovedSymbol["rowElement"] = selectedRow;
		
		symbolData.splice(index, 1);
		allTheData.splice(index, 1);
		parentNode.removeChild(selectedRow);

		//selectedRow = null; --we dont do this anymore because it deallocates the DOM node, we want gLastRemovedSymbol to hold the node

		//	not possible to have a zero
		//	allTheData.length as there has to
		//	be at least one item in the list
		if (index >= allTheData.length)
			index = allTheData.length - 1;
			
		var nextSelection = parentNode.firstChild;
	
		for (var i=0; i<index;++i)
			nextSelection = nextSelection.nextSibling;
			
		if (nextSelection != null)
			clickonbackrow(null, nextSelection);

		//	don't allow deletion of last list item
		if (allTheData.length < 2)
			removeButton.setEnabled(false);
		
		anythingChangedOnBackside = true;
	}
}

function undoLastRemoval() {
	if(gLastRemovedSymbol["index"] != null) { //if the object isnt empty
		allTheData.splice(gLastRemovedSymbol["index"], 0, gLastRemovedSymbol["allTheData"]);
		
		if(gLastRemovedSymbol["symbolData"]) {
			symbolData.splice(gLastRemovedSymbol["index"], 0, gLastRemovedSymbol["symbolData"]);
		}

		var list = $('inner-list');
		var insertedRow = list.insertBefore(gLastRemovedSymbol["rowElement"], list.childNodes[gLastRemovedSymbol["index"]]);
		
		clickonbackrow(null, insertedRow);
		gLastRemovedSymbol = {};
	}
}

function addsymbol(symbol, name, isSelected) {
	var innerList = $('inner-list');
	
	var row = document.createElement('div');
	row.setAttribute('role', 'option');
	row.setAttribute('class',  (isSelected ? 'row select' : 'row') );
	row.setAttribute('tabindex', (isSelected ? '0' : '-1') );
	row.setAttribute('aria-selected', (isSelected ? 'true' : 'false') );
	row.setAttribute("onclick", "clickonbackrow(event, this);");
	
	var span = document.createElement('span');
	span.setAttribute('class', 'col1');
	span.setAttribute('role', 'presentation');
	span.innerText = symbol + ' '; // add one space so calculated text equivalent doesn't concatenate the Symbol and Name w/o a space.
	row.appendChild(span);
	
	span = document.createElement('span');
	span.setAttribute('class', 'col2');
	span.setAttribute('role', 'presentation');
	span.innerText = name;
	row.appendChild(span);
	
	innerList.appendChild(row);
	
	if (isSelected) selectedRow = row;
	
	selectAllInSymbolTextField();

	return row;
}

function selectAllInSymbolTextField() {
	var input = $("symbolinput");
	input.blur();
	input.focus();
	input.select();
}

function calculateWidgetHeight() {
	// top edge + divider + footer + bottom edge + 30px row height
	var height = 8 + 5 + 30 + 16 + (allTheData.length* 30) + carouselPanelHeight;

	if (height < widgetMinHeight) {
		height = widgetMinHeight
	}
	
	return height;
}

function onremove () {
	// remove all the pref pref keys here
	widget.setPreferenceForKey(null, createKey("symbols"));
	widget.setPreferenceForKey(null, createKey("selection"));
	widget.setPreferenceForKey(null, createKey("chartmode"));
	widget.setPreferenceForKey(null, createKey("valueformat"));
}

function createKey (key) {
	return widget.identifier + "-" + key;
}

function setPreferenceForKey (pref, key) {
	// set both the per widget pref and the global
	if (window.widget) {
		widget.setPreferenceForKey(pref, createKey(key));
		widget.setPreferenceForKey(pref, key);
	}
}

function getPreferenceForKey (key, global) {
	// first check to see if we have a per instance one
	var pref = widget.preferenceForKey(createKey(key));
	
	if (pref == null && global) {
		// now check the global one
		pref = widget.preferenceForKey(key);
	}
	//console.log( key + ': ' + pref + '\n' );
	return pref;
}

function createAllDataJSString () {
	var str = "[";
	for (var i = 0; i < allTheData.length; ++i) {
		var data = allTheData[i];
		if (i != 0) {
			str += ",";
		}
		// make sure the name does not have any single quotes in it
		var name = data.name.replace(/\'/g, "\\'");
		str += "{symbol:'" + data.symbol + "',exchange:'" + data.exchange + "',name:'" + name + "'}";
	}
	
	str += "];";
	
	return str;
}

var resizeAnimation = {startTime:0, duration:250, positionFrom:0, positionTo:0, positionNow:0, timer:null, element:null, onfinished:null};

function limit_3 (a, b, c) {
	return a < b ? b : (a > c ? c : a);
}

function computeNextFloat (from, to, ease) {
	return from + (to - from) * ease;
}

function animate () {
	var T;
	var ease;
	var time  = (new Date).getTime();
	var yLoc;
	var frame;
		
	T = limit_3(time-resizeAnimation.startTime, 0, resizeAnimation.duration);
	ease = 0.5 - (0.5 * Math.cos(Math.PI * T / resizeAnimation.duration));

	if (T >= resizeAnimation.duration) {
		yLoc = resizeAnimation.positionTo;
		clearInterval (resizeAnimation.timer);
		resizeAnimation.timer = null;
		
		if (resizeAnimation.onfinished) {
			setTimeout ("resizeAnimation.onfinished();", 0); // call after the last frame is drawn
		}
	} else {
		yLoc = computeNextFloat(resizeAnimation.positionFrom, resizeAnimation.positionTo, ease);
	}
	
	// convert to a integer, not sure if this is the best way
	resizeAnimation.positionNow = parseInt(yLoc);
	resizeAnimation.element.style.height = resizeAnimation.positionNow + "px";
}

function animFinished () {
	if (window.widget) {
		window.resizeTo(widgetWidth, calculateWidgetHeight());
	}
}

function dayclick(event, td, tag) {
	if (td == currentChartSelect && td != null) return;
	
	if (currentChartSelect != null){
		currentChartSelect.setAttribute('class', '');
		currentChartSelect.setAttribute('aria-checked', 'false');
		currentChartSelect.setAttribute('tabindex', '-1');
	}
	
	if (currentChartSelect != td) {
		td.setAttribute ('class', 'selected');
		td.setAttribute('aria-checked', 'true');
		td.setAttribute('tabindex', '0');
		td.focus();
		currentChartSelect = td;
	
		currentChartMode = tag;
		getChartForCurrentMode();
		
		setPreferenceForKey(tag, "chartmode");
	}
}

function getChartForCurrentMode() {
	if (lastChartRequest != null){
		lastChartRequest.abort();
	}
	
	if (currentSelection != null) {
		
		var tag = currentSelection.getAttribute("tag");
		var exchange = currentSelection.getAttribute("stock_exchange");
		lastChartRequest = fetchChartData(generateSymbolStringFromStrings(tag, exchange), currentChartMode, chart_callback);
		enableChart(false);
	
		clearNews();
		clearStockInfo();
	
		// get news
		if (lastNewsRequest != null) {
			lastNewsRequest.abort();
		}
		var symbol = currentSelection.getAttribute("tag");
		var exchange = currentSelection.getAttribute("stock_exchange");
		lastNewsRequest = fetchNewsData(news_callback, [generateSymbolStringFromStrings(symbol, exchange)]);
		
		// repopulate details panel
		quote = getFetchedQuoteData(symbol);
		if (quote) populateStockInfo(quote);
	}
}
function getFetchedQuoteData(symbol){
	for (var i=0, c=allFetchedQuotes.length; i<c; i++) {
		item = allFetchedQuotes[i];
		if (item.symbol == symbol) {
			return item;
		}
	}
	return false;
}

var horizonalLines = new Image();
horizonalLines.src = hidpiPath('./img/chart_gradient.png');

function addElementToVerticalAxes (vaxes, showPrecision, value) {
	var div = document.createElement('div');
	if (showPrecision) {
		div.innerText = value.toFixed(showPrecision).toString();
	} else {
		div.innerText = Math.round(value);
	}

	//make new div first child
	if(vaxes.childNodes.length) {
		vaxes.insertBefore(div, vaxes.firstChild);
	} else {
		vaxes.appendChild(div);
	}
}

function addVerticalAxes(min, max) {
	var numberOfLabels = 4;
	var axisDelta = (max - min) / numberOfLabels;
	var fractionDigits = (axisDelta < 0.02) ? 3 : 2; // Show extra detail for slow-changing symbols like exchange rates (<rdar://problem/5825413>)
	var showPrecision = (axisDelta < MAX_PRICE_DELTA_FOR_FORCED_CENTS_DISPLAY) ? fractionDigits : false; // || (max < MAX_GUARANTEED_CENTS_DISPLAY_PRICE)

	//clear old labels
	var vaxes = $('vertical-axes');
	removeAllChildren(vaxes);

	// Update description of chart image
	// 'Chart displaying %1 market value over %2. High: %3, Low: %4.';
	var label = getLocalizedString('chart_description');
	label = label.replace('%1',currentSelection.getAttribute('title'));
	label = label.replace('%2', $(currentChartMode).getAttribute('aria-label') );
	label = label.replace('%3',max).replace('%4',min);
	$('chartimg').setAttribute('aria-label', label);
	

	var priceRange = (max - min);
	var prevLabelValue = 0, labelValue;
	var labelIndex;
	for (labelIndex = 0; labelIndex < numberOfLabels; labelIndex++) {
		// Calculate stock value for this axis label
		labelValue = min + (priceRange * (labelIndex / (numberOfLabels - 1)));
		addElementToVerticalAxes(vaxes, showPrecision, labelValue);
	}
}

function drawLineWithPoints(points, min, max) {
	var pointCount = points.length;

	// setup the axes and grid
	addVerticalAxes (min, max);
	setupHorizontalAxes (currentChartMode);	
	
	//get the context
	var context = $('chart-canvas').getContext('2d');

	if (pointCount < 2) { // just draw the background
		context.drawImage (horizonalLines, 0, 0, kChartCanvasWidth, kChartCanvasHeight);
	} else {
		//draw line for clipping
		context.beginPath();
		context.save();

		context.moveTo(points[0].x, kChartCanvasHeight);
		context.lineTo(points[0].x, kChartCanvasHeight-points[0].y*kChartCanvasHeight);
		var val;
		for (var i = 0; i < pointCount; ++i) {
			val = points[i];
			//y is unit coordinate off bottom, but canvas coords start in top left. 
			//so we multiply by the chart height and subtract from full height
			context.lineTo (val.x,kChartCanvasHeight-val.y*kChartCanvasHeight);
		}
		//finish line and clip image
		context.lineTo (val.x, kChartCanvasHeight);
		context.clip();
		context.drawImage (horizonalLines, 0, 0, kChartCanvasWidth, kChartCanvasHeight);
		context.restore();

		// then render line
		context.beginPath();
		context.lineWidth = 2.0;
		context.strokeStyle = "rgb(255, 255, 255)";

		context.moveTo(points[0].x, kChartCanvasHeight-points[0].y*kChartCanvasHeight);
		for (var i = 0; i < pointCount; ++i) {
			val = points[i];
			context.lineTo (val.x,kChartCanvasHeight-val.y*kChartCanvasHeight);
		}
		context.stroke();
	}
}

function chart_callback(obj) {
	var points = [];
	var values = [];

	if (!obj.error) {
		try {
			enableChart(false); //clear the canvas
			
			var data = obj.data;
			gChartObj = obj;
			var c = data.length;

			if (obj.data.length > 0) {
				enableChart(true);
				var dataCount = 0;
			
				//set up variables for determining x, y
				var min = obj.min;
				var max = obj.max;
				
				var marketopen = obj.meta.marketopen;
				var marketclose = obj.meta.marketclose;
				var firstTime = data[0].timestep;
				var lastTime = data[data.length-1].timestep;
				var minutesFromLastPointToClose = ((marketclose.getTime()/1000 % (3600 * 24)) - (lastTime % (3600 * 24))) / 60;
				var isCurrencyChart = (minutesFromLastPointToClose < 0); // 24-hour symbols like currency exchange rates.
				var isDayChart = (currentChartMode == "1d" && !isCurrencyChart);
				var graphWidth = $('chart-canvas').clientWidth;
			
				var startX = 0;
				var minuteWidth = 1;

				if (isDayChart) {
					var closeHourFrac = marketclose.getMinutes() / 60.0;
					var openHourFrac = marketopen.getMinutes() / 60.0;
					var closeHour = marketclose.getHours() + (closeHourFrac > 0 ? Math.max(closeHourFrac, (1 - DAY_CHART_MAX_LABEL_ADJUST)) : 0);
					var openHour = marketopen.getHours() + Math.min(openHourFrac, DAY_CHART_MAX_LABEL_ADJUST);
					minuteWidth = graphWidth / ((closeHour - openHour) * 60.0);
					var minutesFromMarketOpenToFirstValue = Math.max(0.0, (firstTime - (marketopen.getTime() / 1000)) / 60.0);
					var minutesFromStartHourToFirstValue = (openHourFrac - Math.min(openHourFrac, DAY_CHART_MAX_LABEL_ADJUST)) * 60.0 + minutesFromMarketOpenToFirstValue;
					startX = minutesFromStartHourToFirstValue * minuteWidth;
				}

				//if 1w chart and trading day isn't over, find where graph should stop
				gFinalPointEndPosition = 1.0;
				if (currentChartMode == "1w") {
					if (minutesFromLastPointToClose > WEEK_CHART_UNFINISHED_MINUTES) {
						var closeMinute = obj.meta.marketclose.getHours() * 60.0 + obj.meta.marketclose.getMinutes();
						var openMinute = obj.meta.marketopen.getHours() * 60.0 + obj.meta.marketopen.getMinutes();
						gFinalPointEndPosition -= (minutesFromLastPointToClose / (closeMinute - openMinute)) / 5; //5 = number of days
					}
					// gFinalPointEndPosition used here for stopping the line. Used in setup1mHorizontalAxes to align axes
					obj.gaps.push(gFinalPointEndPosition);
				}

				// Normalize the step to the number of datapoints available.  If there are plenty, step by the minimum step and interpolate at each.
				var naturalChartStep = (graphWidth - startX - (isCurrencyChart ? 0.0 : minutesFromLastPointToClose * minuteWidth)) / (data.length - 1);
			
				// Slightly incorrect graphs can occur if the interpolation functions are used when we intend to draw each datapoint.
				var useEveryPoint = (naturalChartStep >= MIN_CHART_STEP_STANDARD);

				// Hints about the position of day boundaries for week charts.  This is necessary to ensure perfect alignment even if each day has varying amounts of data.
				var hintCount = obj.gaps.length; 
				var sectionIndex = -1;
				var sectionStart, sectionEnd, nominalSectionSize = 1.0 / hintCount;
				var currentSectionSize = nominalSectionSize;
				var stopPosition = 1.0, stopTime = lastTime + 1.0;
				var weekAlignmentHints = (hintCount > 0 && currentChartMode == "1w");
				if (weekAlignmentHints) {
					stopPosition = obj.gaps[obj.gaps.length-1];    // The last hint gives the end position for the graph, to handle week data ending with an unfinished day.
				}

				var stepX = useEveryPoint ? naturalChartStep : MIN_CHART_STEP_STANDARD;

				var x = startX, lastX, price;
				var dataPosition = 0.0, graphPosition = startX / graphWidth;

				var valueIndex = 0;
				var valueCount = data.length;
				var time = 0.0, prevTime = 0.0, timeOfMin = parseInt(min.timestep), timeOfMax = parseInt(max.timestep);

				while (valueIndex < valueCount && graphPosition <= stopPosition && (!isDayChart || prevTime < lastTime)) {
					if (isDayChart) {
						if (time == stopTime) { //end of a line
							drawLineWithPoints(points, min.close, max.close);
							points = [];
							var index = obj.gaps[sectionIndex]; //gaps is an array of indices in the data
							var valueAfterGap = data[index];
							time = parseInt(valueAfterGap.timestep);
							x = (time - firstTime) / 60.0 * minuteWidth + startX;
							firstTime = time;
							startX = x;
							price = valueAfterGap.close;
							stopTime = -1.0;
							dataPosition += 1.0 / (valueCount - 1);
						} else if (useEveryPoint) {
							var currentValue = data[valueIndex];
							price = currentValue.close;
							time = parseInt(currentValue.timestep);
							x = (time - firstTime) / 60.0 * minuteWidth + startX;
							valueIndex++;
						} else { //dont use every point, extrapolate between points
							time = Math.min(((x - startX) / minuteWidth) * 60.0 + firstTime, Math.min(lastTime, stopTime));
							var priceAndPosition = priceAndPositionAtTime(time, dataPosition, valueIndex, valueCount, data);
							price = priceAndPosition["price"];
							dataPosition = priceAndPosition["position"];
						}

						if (sectionIndex == -1 || stopTime == -1.0) {
							sectionIndex++;
							var index = sectionIndex < hintCount ? obj.gaps[sectionIndex] : valueCount;
							stopTime = parseInt(data[index - 1].timestep);
							if (stopTime == lastTime) stopTime++;
						}
					} else if (useEveryPoint) { //end isDayChart
						var currentValue = data[valueIndex];
						price = currentValue.close;
						time = parseInt(currentValue.timestep);
						valueIndex++;
					} else {
						time = timeAtPosition(dataPosition, valueCount, data);
						var priceAndPosition = priceAndPositionAtTime(time, dataPosition, valueIndex, valueCount, data);
						price = priceAndPosition["price"];
					}

					// Ensure the step size doesn't cause us to miss the minimum or maximum of the graph.  Save the lastX first.
					var minPrice = min.close;
					var maxPrice = max.close;
					lastX = x;
					if (!useEveryPoint || isDayChart) {
						if (timeOfMin > prevTime && timeOfMin < time) {
							time = timeOfMin;
							price = minPrice;
							x = isDayChart ? ((timeOfMin - firstTime) / 60.0 * minuteWidth + startX) : (x - stepX * ((-(timeOfMin - prevTime) / (time - prevTime)) + 1));
							lastX -= stepX;
							timeOfMin = lastTime + 1.0;
						} else if (timeOfMax > prevTime && timeOfMax < time) {
							time = timeOfMax;
							price = maxPrice;
							x = isDayChart ? ((timeOfMax - firstTime) / 60.0 * minuteWidth + startX) : (x - stepX * ((-(timeOfMax - prevTime) / (time - prevTime)) + 1));
							lastX -= stepX;
							timeOfMax = lastTime + 1.0;
						}
					}
			
					dataCount++;

					points.push({x:x, y:((price - minPrice) / (maxPrice - minPrice))}); // y is in unit coordinates so the line can be redrawn at varying view heights.
					values.push({time:time, price: price});
		
					// Increment X, and recalculate the progress in the graph.
					x = lastX + stepX;
					prevTime = time;
					// If the next step is off the graph, but we still didn't reach the end with the last step, finish it up.
					if (x > graphWidth && lastX < graphWidth) x = graphWidth;

					graphPosition = x / graphWidth;
					if (graphPosition > stopPosition && lastX / graphWidth < stopPosition) {
						graphPosition = stopPosition;
					}

					if (weekAlignmentHints) {
						var currentSectionIndex = Math.min(Math.floor(graphPosition / nominalSectionSize), hintCount - 1);
						if (currentSectionIndex != sectionIndex) {
							sectionIndex = currentSectionIndex;
							sectionStart = (sectionIndex == 0 ? 0.0 : obj.gaps[sectionIndex-1]);
							sectionEnd = (sectionIndex == hintCount - 1 ? 1.0 : obj.gaps[sectionIndex]);
							if (sectionIndex == hintCount - 1) {
								currentSectionSize = stopPosition - graphPosition;
							}
						}
						dataPosition = Math.min(sectionStart + ((graphPosition - sectionIndex * nominalSectionSize) * (sectionEnd - sectionStart) / currentSectionSize), 1.0);
					} else if (!isDayChart) {
						dataPosition = graphPosition;
					}
				} //end while
				
				
				drawLineWithPoints(points, min.close, max.close);
				points = [];
				
			} else {
				$('retrieving').innerText = getLocalizedString('No chart data');
			}
		} catch(e) {
			if (console) console.error(e);
		}
	} else {
		var chartMessage;
		if(obj.error == kNoIntradayChartError) {
			chartMessage = getLocalizedString('No Intraday Chart Available');
		} else {
			chartMessage = getLocalizedString('Error retrieving chart');
			if (console) console.error('fetching chart failed: ' + obj.errorString);
		}
		
		enableChart(false);
		$('retrieving').innerText = chartMessage;
	}
}


// Returns an interpolated price at an absolute time in the data from [0, 1].  This method is stateless.
function timeAtPosition(percentPosition, valueCount, data) {
	// ASSERT(percentPosition <= 1.0);
	var floatingIndex = percentPosition * (valueCount - 1);
	var roundedIndex = Math.floor(floatingIndex);
	if (roundedIndex >= valueCount - 1) {
		return parseInt(data[valueCount - 1].timestep);
	}
	var earlierTime = parseInt(data[roundedIndex].timestep);
	if (roundedIndex + 1 >= valueCount - 1){
		return earlierTime;
	}
	var laterTime = data[roundedIndex+1].timestep;
	var midpointFactor = (floatingIndex - roundedIndex);
	if (laterTime - earlierTime > 3600 * 12) { // If there is more than 12 hours between these datapoints, don't interpolate.  Could be on the gap between trading days.
		midpointFactor = Math.round(midpointFactor);
	}
	return earlierTime * (1 - midpointFactor) + laterTime * midpointFactor;
}

// Returns an interpolated price at an absolute time in the data.
// This method is stateful, as the search start is based on the current _valueIndex.
function priceAndPositionAtTime (time, dataPosition, valueIndex, valueCount, data) {
	if (valueIndex > valueCount - 1){
		return {price: data[_valueCount - 1].close, position: dataPosition};
	} else if (valueIndex < 1) {
		valueIndex = 1;
	}
	
	var earlierValue = data[valueIndex-1];
	var laterValue = data[valueIndex];
	while (time > laterValue.timestep) {   // Advance through the data in pairs until the pair straddles the time we want.
		earlierValue = laterValue;
		valueIndex++;
		if (valueIndex == valueCount) {
			if (dataPosition) dataPosition = 1.0;
			return {price: data[valueCount - 1].close, position: dataPosition};
		}
		laterValue = data[valueIndex];
	}

	var midpointFactor = (time - earlierValue.timestep) / (laterValue.timestep - earlierValue.timestep);
	if (dataPosition) {
		dataPosition = (valueIndex + midpointFactor) / (valueCount - 1);
	}
	var price = earlierValue.close * (1 - midpointFactor) + laterValue.close * midpointFactor;
	return {price: price, position: dataPosition};
}


// workaround for canvas not rendering after display change.
function enableChart(enable) {
	var img = $('chartimg');
	var canvas = $('chart-canvas');
	var retrieving = $('retrieving');
	
	// set the scale for the canvas
 	var scaleFactor = window.devicePixelRatio;
 	canvas.width = kChartCanvasWidth * scaleFactor;
 	canvas.height = kChartCanvasHeight * scaleFactor;
 	canvas.getContext('2d').scale(scaleFactor, scaleFactor);
	
	if (enable) {
		img.style.display = 'block';
		retrieving.style.display='none';
	} else {
		retrieving.innerText = getLocalizedString('Retrieving Chart…');
		retrieving.style.display='block';
		img.style.display = 'none';
		
		// clear the canvas
		canvas.getContext('2d').clearRect(0, 0, kChartCanvasWidth, kChartCanvasHeight);
	}
}

function setupChartController(mode) {
	var array = ['1d', '1w', '1m', '3m', '6m', '1y', '2y'];
	var c = array.length;
	
	for (var i = 0; i < c; ++i) {
		var m = array[i];
		var el = $(m);
		el.innerHTML = getLocalizedString(m);
		
		if (m == mode){
			if (currentChartSelect != null){
				currentChartSelect.setAttribute('class', '');
				currentChartSelect.setAttribute('aria-checked', 'false');
				currentChartSelect.setAttribute('tabindex', '-1');
			}
			
			currentChartSelect = el;
			currentChartSelect.setAttribute('class', 'selected');
			currentChartSelect.setAttribute('aria-checked', 'true');
			currentChartSelect.setAttribute('tabindex', '0');
		}
	}
}

function changeChartMode(e, direction) {
	var el =  null;
	if (currentChartMode) el = $(currentChartMode);
	if (!el) return;
	if (direction == 'prev') {
		el = el.previousSibling;
		// make sure this is the previous Element (nodeType 1), not a Text node (nodeType 3)
		while (el.nodeType != 1 && el.previousSibling) {
			el = el.previousSibling;
		}
	} else if (direction == 'next') {
		el = el.nextSibling;
		// make sure this is the next Element (nodeType 1), not a Text node (nodeType 3)
		while (el.nodeType != 1 && el.nextSibling) {
			el = el.nextSibling;
		}
	}
	if (el && el.id){
		dayclick(e, el, el.id);
	}
	e.stopPropagation();
	e.preventDefault();
}

function getMonthArray() {
	return getLocalizedString("Jan Feb Mar Apr May Jun Jul Aug Sep Oct Nov Dec").split(" ");
}

function oneDayHorizontalLabels () {
	if(!gChartObj || !gChartObj.meta) {
		return [];
	}
	var labelArray = [];
	var gmtoffset = gChartObj.meta.gmtoffset;
	var openHour = gChartObj.meta.marketopen.getUTCHours() + gmtoffset;
	var closeHour = Math.ceil(gChartObj.meta.marketclose.getUTCHours() + gmtoffset + gChartObj.meta.marketclose.getMinutes() / 60.0);
	var hourRange = closeHour - openHour;

	var hourLabels = [];
	for (; closeHour > openHour; closeHour--) {     // Labels and positions in reverse order, right to left.
		hourLabels.push(closeHour > 12 ? closeHour % 12 : closeHour);
	}
	
	// Now calculate the hour positions to maximize space on the left and right if the market opens and/or closes off even hours.
	var hourPositions = [];
	var labelIndex = hourRange;    // Use a float to force float results in calculations.
	var positionAtRight = 1.0;
	var gapForEachLabel = 1.0 / labelIndex;
	
	// Calculate the amount to append to the second to last hour to show enough of the partial last hour.
	var hourFractionToAppend = Math.min(gChartObj.meta.marketclose.getMinutes() / 60.0, DAY_CHART_MAX_LABEL_ADJUST);
	if (hourFractionToAppend > 0.0) {
		// Draw a blank vertical line to mark the true end of the graph before the y-scale.
		hourLabels.unshift("");
		hourPositions.unshift(1);
		gapForEachLabel += ((1 - hourFractionToAppend) / labelIndex) / labelIndex;
		labelIndex--;
	}
	
	// Calculate the amount to prepend to the second hour to show enough of the partial first hour.
	var hourFractionToPrepend = Math.min(gChartObj.meta.marketopen.getMinutes() / 60.0, DAY_CHART_MAX_LABEL_ADJUST);
	gapForEachLabel += (hourFractionToPrepend / labelIndex) / labelIndex;

	// Now that gapForEachLabel is finalized, calculate where the first drawn label (at the right) should be, if time was appended.
	positionAtRight -= gapForEachLabel * hourFractionToAppend;

	// And loop to calculate the position of each hour thereafter.
	for(; labelIndex > 0; labelIndex--) {
		hourPositions.push(positionAtRight);
		positionAtRight -= gapForEachLabel;
	}
	
	for(index in hourLabels) {
		if(!hourPositions[index]) hourPositions[index] = 0;
		labelArray.push([hourLabels[index], hourPositions[index]]);
	}
	
	return labelArray;
}

function dayLabelsForHorizontalAxes (daysPerLabel, realTimePositions) {

	// Build labels: start at the latest day and work backwards until dayLabelCount days have been encountered
	var labelArray = [];
	var labels = [];
	var dayBoundaryIndexes = [];
	var currentDay = -1;
	var skipDays = daysPerLabel == 1 ? daysPerLabel : 0; // Use first day we find
	var valueIndex = gChartObj.data.length;
	var currentMonth = 0;  // Months are 1-indexed.
	var secondsFromGMT = gChartObj.meta.gmtoffset;

	//label in week view is start of that days data, but in month view shows just that point's data
	var labelReflectsBeginningOfPeriod = (daysPerLabel == 1); 

	var valueTime;
	var valueDate;
	var data = gChartObj.data;
	var lastDate = null;

	while (valueIndex--) {
		valueTime = data[valueIndex].timestep; // - 978307200.0; //NSTimeIntervalSince1970;
		valueDate = new Date(valueTime *1000); //CFAbsoluteTimeGetGregorianDate(valueTime, (CFTimeZoneRef)chartDataTimeZone);

		var absoluteDay = Math.floor((valueTime + secondsFromGMT) / 86400.0);

		if (absoluteDay != currentDay) {

			// Calculate the number of days between this date and the previously processed date (i.e. the date immediately after this date, chronologically)
			var daysSinceCurrentDay = (currentDay == -1) ? 0 : currentDay - absoluteDay;

			if (daysSinceCurrentDay >= 1) {
				dayBoundaryIndexes.push(valueIndex);
			}

			// Skip days until daysPerLabel days have been skipped.
			// Note that daysPerLabel is expressed in terms of the true calendar and not the dates represented in _stockValues.
			// For example, there are 7 days between these 5 days: { 1, 2, 3, 4, 7 }
			skipDays -= daysSinceCurrentDay;

			if (skipDays <= 0) {
				skipDays = daysPerLabel; //reset skipDays
				if(!lastDate) lastDate = valueDate; //first time in month view

				// Add label for this day
				var labelString = labelReflectsBeginningOfPeriod ? lastDate.getUTCDate() : valueDate.getUTCDate();

				//-1 signals use equal spacing
				var position = realTimePositions ? valueIndex / (data.length-1) : -1;

				labelArray.push([labelString, position]);
			}
			
			// Remember this absolute day
			lastDate = valueDate;
			currentDay = absoluteDay;
		}
	}

	//we had calculated position based on index's position in data
	//if last trading day in week isn't over, need to recalculate accounting for time bt last data point and end of day
		//use the ratio is currentPosition/dataLength = newPosition/totalLength
		//if totalLength = 1, dataLength is gFinalPointEndPosition
	//gFinalPointEndPosition is calculated in chart_callback
	if (currentChartMode == "1w") {
		labelArray.push([lastDate.getUTCDate(), 0]); //add one more for week view
		
		if(gFinalPointEndPosition < 1) {
			for(var i = 0; i < labelArray.length-1; i++) { //all but the index 0, which has latest date
				labelArray[i][1] = labelArray[i][1] * gFinalPointEndPosition; //(data.length-1) / ((data.length-1)/gFinalPointEndPosition);
			}
		}
	}

	return labelArray;
}

function monthLabelsWithInterval (interval) {
	var labelArray = [];
	var data = gChartObj.data;
	var valueIndex = data.length;
	var lastTime = data[data.length-1].timestep;
	var lastMonth = new Date(lastTime*1000).getMonth();
	var labels = getMonthArray ();
	var skipMonths = interval;
	var firstMonthLabeled = -1;
	var showYearLabels = interval >= 4;

	while (valueIndex--) {
		var currentDate = new Date(data[valueIndex].timestep * 1000);
		var currentMonth = currentDate.getMonth();
		
		if(currentMonth != lastMonth) {
			skipMonths--;
			if(skipMonths == 0) {
				if(firstMonthLabeled == -1) {
					firstMonthLabeled = lastMonth;
				}
				var label;
				if(showYearLabels && lastMonth == firstMonthLabeled) {
					label = labels[lastMonth].substring(0, 1) + "'" + currentDate.getFullYear().toString().substring(2);
				} else {
					label = labels[lastMonth]; //print the month we're leaving
				}
				
				labelArray.push([label, valueIndex/(data.length-1)]);
				skipMonths = interval;
			}
			lastMonth = currentMonth;
		}
	}
	return labelArray;
}

function setupHorizontalAxes (mode) {
	var xaxes = $('horizontal-axes');
	removeAllChildren(xaxes);
	var labelArray = [];
	switch (mode) {
		case "1d": labelArray = oneDayHorizontalLabels(); break;
		case "1w": labelArray = dayLabelsForHorizontalAxes(1, true); break;
		case "1m": labelArray = dayLabelsForHorizontalAxes(7, true); break;
		case "3m": labelArray = monthLabelsWithInterval(1); break;
		case "6m": labelArray = monthLabelsWithInterval(1); break;
		case "1y": labelArray = monthLabelsWithInterval(2); break;
		case "2y": labelArray = monthLabelsWithInterval(4); break;
	}

	var context = $('chart-canvas').getContext('2d');
	context.beginPath();
	context.save();
	context.lineWidth = 2;
	context.strokeStyle = "rgb(63, 78, 119)";
	
	var hasDrawnLineAtRightEdge = false;
	
	for(index in labelArray) {
		var labelPositionPair = labelArray[index];

		var label = labelPositionPair[0];
		var position = labelPositionPair[1];

		if (position < 0) { //negative means evenly space the labels
			position = (labelArray.length-1-index)/(labelArray.length-1);
		}
		
		var div = document.createElement('div');
		div.innerText = label;
		div.setAttribute("class", "xaxes");
		xaxes.appendChild(div);
		var left = Math.round( position*kChartCanvasWidth - (div.clientWidth/2) + kOffsetBtCanvasAndXAxes );
		div.style.left = left + "px";
		if (left < div.clientWidth/2 + 5) {
			div.style.display = 'none'; // don't show a label too close to the left edge
		}
		
		//draw a vertical line at that point
		skip = false;
		var xpos = Math.floor(position*kChartCanvasWidth)-1;
		if (xpos < 5) {
			skip = true; // don't draw a vertical rule too close to the left edge
		}
		if (!skip) {
			context.moveTo(xpos, kChartCanvasHeight);
			context.lineTo(xpos, 0);
			context.stroke();
		}
		
	}

	if (!hasDrawnLineAtRightEdge) {
		//draw the right edge
		context.moveTo(kChartCanvasWidth-1, 0);
		context.lineTo(kChartCanvasWidth-1, kChartCanvasHeight);
		context.stroke();
	}

}

var panels = [];
var panelIndex = 0;
var lastPanelIndex = 0;
var activePanel = false;
var lastActivePanel = false;
function nextPanel(){
	cyclePanels('next');
}
function prevPanel(){
	cyclePanels('prev');
}
function selectPanel(inIndex){
	if (inIndex == panelIndex) return;
	// determine if ID is next or prev panel, then call cyclePanels()
	var prevIndex = panelIndex-1;
	if (prevIndex < 0) prevIndex = panels.length-1;
	if (prevIndex == inIndex){
		prevPanel();
	} else {
		nextPanel();
	}
}
function cyclePanels(inDirection){
	var dir = inDirection;
	lastPanelIndex = panelIndex;
	if (dir != 'prev') dir = 'next';
	for (var i=0, c=panels.length; i<c; i++) {
		var item = panels[i];
		if (item.className.match('active')) {
			panelIndex = i;
			activePanel = item;
		}
	}
	if (dir == 'prev'){
		// previous panel
		panelIndex--;
		if (panelIndex < 0) panelIndex = panels.length-1;
	} else {
		// next panel
		panelIndex++;
		if (panelIndex >= panels.length) panelIndex = 0;
	}
	lastActivePanel = activePanel;
	activePanel = panels[panelIndex];
	updatePanelSelectorUI();
}

function updatePanelSelectorUI(){
	
/*
	lastActivePanel.className = 'panel';
	activePanel.className = 'panel active';
*/
	lastActivePanel.classList.remove("active");
	activePanel.classList.add("active");
	
	if (panelIndex == 0) {
		getChartForCurrentMode(); // explicitly redraw the chart when shown
	}
	
	// todo: animate this in/out
	activePanel.style.display = 'block';
	lastActivePanel.style.display = 'none';
	
	// update the 3 highlighted dots
	var radios = $('panel_radiogroup').getElementsByTagName('span');
	radios[lastPanelIndex].setAttribute('aria-checked', 'false');
	radios[panelIndex].setAttribute('aria-checked', 'true');
	
}

function financeLogoClick(evt) {
	openLink('http://api.apple.go.yahoo.com/appledwf/');
}

function yLogoClick(evt) {
	var url = "http://api.apple.go.yahoo.com/appledwf/q/cq?d=v1";
	for (var i = 0; i < allTheData.length; i++) {
		var symbol = allTheData[i].symbol;
		symbol = ("COMPX" == symbol) ? "^IXIC" : symbol;
		url += "&s=" + symbol;
	}
	openLink(url);
}

function openLink(url){
	if (window.widget) {
		widget.openURL(url);
	} else {
		window.location = url;
	}
	return false;
}

function debug(msg) {
	if (!debug.box) {
		debug.box = document.createElement("div");
		debug.box.setAttribute("style", "background-color: white; " +
										"font-family: monospace; " +
										"border: solid black 3px; " +
										"position: absolute;top:40px;" +
										"padding: 10px;");
		document.body.appendChild(debug.box);

	}
	
	var p = document.createElement("p");
	p.appendChild(document.createTextNode(msg));
	debug.box.appendChild(p);
}


