// https://www.deepl.com/pro-api
var deeplAuthKey = ""



//-------------------------------------------------------------------------------------

/*
This widget originally pulled data from Systran.
I (Wowfunhappy) have modified it to use Deepl instead.

Copyright (c) 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/


function performXMLRequest (encodedText, encodingType, translationType, callback)
{    
    var sourceLang = translationType.substr(0, translationType.indexOf('_')).toUpperCase();
    var targetLang = translationType.substr(translationType.indexOf('_') + 1, translationType.length).toUpperCase();
    
    var url = 'https://api-free.deepl.com/v2/translate?auth_key=' + deeplAuthKey + '&text=' + encodeURI(encodedText) + "&source_lang=" + sourceLang + "&target_lang=" + targetLang;
    
    var xml_request = new XMLHttpRequest();
    xml_request.onload = function(e) {xml_loaded(e, xml_request, requestID++, callback);}
    xml_request.onerror = function() {callback(null,"");}
    xml_request.open("GET", url);
    xml_request.setRequestHeader("Cache-Control", "no-cache");
    xml_request.send(null);
    
    //alert("Translation URL: " + url); //uncomment for debugging
    
    return xml_request;
}

function xml_loaded (e, xml_request, id, callback)
{
	if (!isXMLRequestLastOneSent(xml_request))
		return;
    
    if ( xml_request.responseText ) {
        var response = xml_request.responseText;
        var json = JSON.parse(response);
        var data = htmlDecode(json.translations[0].text);
        
        //Wowfunhappy: I assume this id stuff prevents duplicate requests, but haven't looked into how it works.
        if ( id < receiveID ) {
            debug("old request: " + id);
            return;
        }
        receiveID = id;
        
        callback(data, null);
    }
    else
        callback(null, "");
        
    clearLastXMLRequest();
}

//https://stackoverflow.com/a/46851765/6358721
function htmlDecode(input){
    var el = document.createElement('div');
    return input.replace(/\&#?[0-9a-z]+;/gi, function (enc) {
        el.innerHTML = enc;
        return el.innerText
    });
}