// https://pirate-weather.apiable.io/
var pirateWeatherApiKey = ""



//-------------------------------------------------------------------------------------

/*
This Apple widget originally (at different times) pulled data from accuweather or weather.com. Both APIs died in 2019.
I (Wowfunhappy) have heavily modified this file to use the Pirate Weather API instead.

Copyright ＿ 2005, Apple Computer, Inc.  All rights reserved.
NOTE:  Use of this source code is subject to the terms of the Software
License Agreement for Mac OS X, which accompanies the code.  Your use
of this source code signifies your agreement to such license terms and
conditions.  Except as expressly granted in the Software License Agreement
for Mac OS X, no other copyright, patent, or other intellectual property
license or right is granted, either expressly or by implication, by Apple.
*/

var accuweatherIcons = 
[
	["sun"], 					// 1 Sunny
	["sun"],					// 2 Mostly Sunny
	["partlycloudy"],				// 3 Partly Sunny
	["partlycloudy"],				// 4 Intermittent Clouds
	["sun", "haze"],				// 5 Hazy Sunshine
	["partlycloudy"],				// 6 Mostly Cloudy
	["clouds"],					// 7 Cloudy (am/pm)
	["clouds"],					// 8 Dreary (am/pm)
	null,						// 9 retired
	null,						// 10 retired
	["fog"],					// 11 fog (am/pm)
	["rain"],					// 12 showers (am/pnm)
	["rain&clouds"],				// 13 Mostly Cloudy with Showers
	["rain&sun"],					// 14 Partly Sunny with Showers
	["lightening"],					// 15 Thunderstorms (am/pm)
	["lightening"],					// 16 Mostly Cloudy with Thunder Showers
	["lightening"],					// 17 Partly Sunnty with Thunder Showers
	["rain"],					// 18 Rain (am/pm)
	["flurries"],					// 19 Flurries (am/pm)
	["flurries"],					// 20 Mostly Cloudy with Flurries
	["flurries"],					// 21 Partly Sunny with Flurries
	["snow"],					// 22 Snow (am/pm)
	["snow"],					// 23 Mostly Cloudy with Snow
	["ice"],					// 24 Ice (am/pm)
	["hail"],					// 25 Sleet (am/pm)
	["hail"],					// 26 Freezing Rain (am/pm)
	null,						// 27 retired
	null,						// 28 retired
	["rain&snow"],					// 29 Rain and Snow Mixed (am/pm)
	["sun"],					// 30 Hot (am/pm)
	["sun"],					// 31 Cold (am/pm)
	["wind"],					// 32 Windy (am/pm)
	// Night only Icons
	["moon"],					// 33 Clear
	["moon"],					// 34 Mostly Clear
	["moon", "partlycomboclouds"],			// 35 Partly Cloudy
	["moon", "partlycomboclouds"],			// 36 Intermittent Clouds
	["moon", "haze"],				// 37 Hazy
	["moon", "partlycomboclouds"],			// 38 Mostly Cloudy
	["rain&clouds"],				// 39 Partly Cloudy with Showers
	["rain&clouds"], 				// 40 Mostly Cloudy with Showers
	["lightening"],					// 41 Partly Cloudy with Thunder Showers
	["lightening"],					// 42 Mostly Cloudy with Thunder Showers
	["snow"],					// 43 Mostly Cloudy with Flurries
	["snow"]					// 44 Mostly Cloudy with Flurries
];

var accuweatherMiniIcons = 
[
	"sun", 						// 1 Sunny
	"sun",						// 2 Mostly Sunny
	"suncloud",					// 3 Partly Sunny
	"suncloud",					// 4 Intermittent Clouds
	"sunhaze",					// 5 Hazy Sunshione
	"suncloud",					// 6 Mostly Cloudy
	"clouds",					// 7 Cloudy (am/pm)
	"clouds",					// 8 Dreary (am/pm)
	null,						// 9 retired
	null,						// 10 retired
	"fog",						// 11 fog (am/pm)
	"rain",						// 12 showers (am/pnm)
	"cloudrain",					// 13 Mostly Cloudy with Showers
	"sunrain",					// 14 Partly Sunny with Showers
	"lightening",					// 15 Thunderstorms (am/pm)
	"lightening",					// 16 Mostly Cloudy with Thunder Showers
	"lightening",					// 17 Partly Sunnty with Thunder Showers
	"rain",						// 18 Rain (am/pm)
	"flurries",					// 19 Flurries (am/pm)
	"flurries",					// 20 Mostly Cloudy with Flurries
	"flurries",					// 21 Partly Sunny with Flurries
	"snow",						// 22 Snow (am/pm)
	"snow",						// 23 Mostly Cloudy with Snow
	"ice",						// 24 Ice (am/pm)
	"hail",						// 25 Sleet (am/pm)
	"hail",						// 26 Freezing Rain (am/pm)
	null,						// 27 retired
	null,						// 28 retired
	"snowrain",					// 29 Rain and Snow Mixed (am/pm)
	"sun",						// 30 Hot (am/pm)
	"sun",						// 31 Cold (am/pm)
	"wind",						// 32 Windy (am/pm)
	// Night only Icons (shouldn't get these);
	null,						// 33 Clear
	null,						// 34 Mostly Clear
	null,						// 35 Partly Cloudy
	null,						// 36 Intermittent Clouds
	null,						// 37 Hazy
	null,						// 38 Mostly Cloudy
	null,						// 39 Partly Cloudy with Showers
	null,			 			// 40 Mostly Cloudy with Showers
	null,						// 41 Partly Cloudy with Thunder Showers
	null,						// 42 Mostly Cloudy with Thunder Showers
	null,						// 43 Mostly Cloudy with Flurries
	null						// 44 Mostly Cloudy with Flurries
];

//Experiment to find the right number. Don't reference the above arrays, those numbers are different. Don't understand why.
var getAccuweatherIconNumFromDarkSkyIcon = {
	"clear-day": 1,
	"clear-night": 33,
	"rain": 11,
	"snow": 22,
	"sleet": 28,
	"wind": 31,
	"fog": 10,
	"cloudy": 7,
	"partly-cloudy-day": 2,
	"partly-cloudy-night": 35,

	//Inferred icons
	"freezing-rain": 24,
	"flurries": 19,
	"lightning": 15
};

var MoonMap=[1, 2, 3, 4, 5, 6, 7, 7, 8, 9, 10, 11, 12, 13, 13, 14, 15, 16, 17, 18, 19, 19, 20, 21, 22, 23, 24];

if (window.timerInterval != 300000)
	window.timerInterval = 300000; // 5 minutes




// returns an anonymous object like so
// object
//		error: 	Boolean false for success
//		errorString: failure string
//		hi:		Fahrenheit
//		lo: 		Fahrenheit
//		temp: 	Fahrenheit
//		icon	:	accuweather icon code
//		icons:	our icons to display
//		description:	accuweather description
//		city:	City (first caps)
//		time:	time 24 hours(nn:nn)
//		sunset:	time 24 hours (nn:nn)
//		sunrise: time 24 hours (nn:nn)
//		phases: array[7] of integers; -1 means no phase data 1-24
//		forcast: array[6] of anonymous objects like so
//			object
//				hi:		Fahrenheit
//				lo: 		Fahrenheit
//				icon:	accuweather icon code
//				ouricon:	our icon code to display
//				description: accuweather description
//				daycode:	(MON/TUE/WED/THU/FRI/SAT/SUN)

function fetchWeatherData (callback, lat, lon, name)
{	
	var url = "";
	if (pirateWeatherApiKey) {
		url = 'http://api.pirateweather.net/forecast/' + pirateWeatherApiKey + '/' + lat + ',' + lon + '?exclude=minutely,alerts,flags&units=us';
	} else {
		url = 'http://weather-widget-d916.wowfunhappy.workers.dev/weather|||' + lat + ',' + lon;
	}
	
	if (window.timerInterval != 300000)
		window.timerInterval = 300000; // 5 minutes

	var xml_request = new XMLHttpRequest();
	xml_request.onload = function(e) {xml_loaded(name, e, xml_request, callback);}
	xml_request.open("GET", url);
	xml_request.setRequestHeader("Cache-Control", "no-cache");
	xml_request.send(null);
		
	//widget.openURL(url); //uncomment for debugging
	
	return xml_request;
}

function constructError (string)
{
	return {error:true, errorString:string};
}

// parses string of the form nn:nn
function parseTimeString(string)
{
	var obj = null;
	try {
		var array = string.match (/\d{1,2}/g);
		
		obj = {hour:parseInt(array[0], 10), minute:parseInt(array[1],10)};
	}
	catch (ex)
	{
		// ignore
	}
	
	return obj;
}

//Apple expects time to come in format nn:nn
function makeTimeString(unixTime) {
	return new Date(unixTime * 1000).toTimeString();
}

function getDayOfWeek(unixTime, utcOffset) {
	var weekArray = ["SUN", "MON", "TUE", "WED", "THU", "FRI", "SAT"]
	
	//DarkSky's documentation says that using the timezone offset will result in DST bugs... But, I don't know how else to do it! 
	
	var date = new Date((unixTime + utcOffset * 3600) * 1000);
	var dayNum = date.getUTCDay();
	return weekArray[dayNum];
}

function xml_loaded (cityName, event, request, callback)
{
	if (request.responseText)
	{
		var json = parseJson(request.responseText);
		var obj = {error:false, errorString:null};
		
		var CurrentConditions = json.currently
		
		obj.time = makeTimeString(CurrentConditions.time);
		obj.city = cityName;
		obj.temp = parseInt(CurrentConditions.temperature);
		obj.description = CurrentConditions.summary
		
		var icon;
		if (CurrentConditions.icon === "rain" && CurrentConditions.summary.toLowerCase().indexOf("freezing rain") !== -1) {
			icon = "freezing-rain";
		}
		else if (CurrentConditions.icon === "snow" && CurrentConditions.summary.toLowerCase().indexOf("flurries") !== -1) {
			icon = "flurries";
		}
		else if (typeof json.alerts !== "undefined" && (json.alerts.title.toLowerCase().indexOf("lightning") !== -1 || json.alerts.title.toLowerCase().indexOf("thunder") !== -1)) {
			icon = "lightning";
		}
		else {
			icon = CurrentConditions.icon;
		}
		var accuweatherIconNum = getAccuweatherIconNumFromDarkSkyIcon[icon];
		obj.icon = accuweatherIconNum;
		obj.icons = accuweatherIcons[accuweatherIconNum];
		
		obj.hi = parseInt(json.daily.data[0].temperatureHigh);
		obj.lo = parseInt(json.daily.data[0].temperatureLow);
		
		obj.sunset = makeTimeString(json.daily.data[0].sunsetTime);
		obj.sunrise = makeTimeString(json.daily.data[0].sunriseTime);
		
		var lunationNum = parseFloat(json.daily.data[0].moonPhase);
		obj.phase = MoonMap[parseInt(Math.round(lunationNum * (MoonMap.length - 1)))];
		
		obj.forecast = new Array;
		var Forecast = json.daily.data;
		if (Forecast == null) {callback(constructError("no <Forecast>")); return;}
		
		for (i = 0; i < 6; i++) {
			var foreobj = {description:null, hi:0, lo:0, icon:-1};
			
			//Likely accessibility-related; not normally visible anywhere in the widget. Untested.
			foreobj.description = json.daily.data[i].summary;
			
			foreobj.hi = parseInt(json.daily.data[i].temperatureHigh);
			foreobj.lo = parseInt(json.daily.data[i].temperatureLow);

			var icon;
			if (json.daily.data[i].icon === "rain" && json.daily.data[i].summary.toLowerCase().indexOf("freezing rain") !== -1) {
				icon = "freezing-rain";
			}
			else if (json.daily.data[i].icon === "snow" && json.daily.data[i].summary.toLowerCase().indexOf("flurries") !== -1) {
				icon = "flurries";
			}
			else {
				icon = json.daily.data[i].icon;
			}

			var accuweatherIconNum = getAccuweatherIconNumFromDarkSkyIcon[icon];
			foreobj.icon = accuweatherIconNum;
			foreobj.ouricon = accuweatherMiniIcons[accuweatherIconNum];
			
			foreobj.daycode = getDayOfWeek(json.daily.data[i].time, json.offset);
			
			obj.forecast[i]=foreobj;
		}
		
		callback (obj);
	}
	else
	{
		callback ({error:true, errorString:"request failed. no response"});
	}
}

function validateWeatherLocation (location, callback)
{
	var url = ""
	var userAgent = ""
	if (window.JSON && typeof JSON.parse === 'function') {
		// We can parse JSON, which means we're on at least Snow Leopard.
		// Either this system can connect to OSM natively, or the user can install AquaProxy.
		url = 'https://nominatim.openstreetmap.org/search?format=jsonv2&addressdetails=1&q=';
		// Nominatim's usage policy says we must provide a UA identifying the application
		userAgent = "Mac Weather Widget - Wowfunhappy Mod"
	} else {
		url = 'http://weather-widget-d916.wowfunhappy.workers.dev/location|||';
	}
	
	var xml_request = new XMLHttpRequest();
	xml_request.onload = function(e) {xml_validateloaded(e, xml_request, callback);}
	xml_request.overrideMimeType("text/xml");
	xml_request.open("GET", url+location);
	xml_request.setRequestHeader("Cache-Control", "no-cache");
	if (userAgent) {
		xml_request.setRequestHeader("User-Agent", "Mac Weather Widget - Wowfunhappy Mod");
	}
	xml_request.send(null);
}

function xml_validateloaded (event, request, callback)
{
	if (request.responseText)
	{
		var json = parseJson(request.responseText);
		var obj = {error:false, errorString:null, cities:new Array, refine:false};
		
		for (i = 0; i < json.length; i++) {
			
			var city = json[i].address.city || json[i].address.town;
			var state = json[i].address.state || json[i].address.country;

			var lat = json[i].lat;
			var lon = json[i].lon;
		
			if (city && state && lat && lon) {
				if (
					obj.cities.length === 0 ||
					city !== obj.cities[obj.cities.length - 1].name ||
					state !== obj.cities[obj.cities.length - 1].state
				) {
					obj.cities[obj.cities.length] = {name:city, state:state, zip:"", lat: lat, lon: lon};
				}
			}
		}
		
		callback (obj);
	}
	else
	{
		callback ({error:true, errorString:"request failed. no response"});
	}
}

/*Used for compatibility with Tiger, which does not support JSON.parse()*/
/*Eval is unsafe, so be careful not to use it unless absolutely necessary!*/
function parseJson(json) {
	if (window.JSON && typeof JSON.parse === 'function') {
		return JSON.parse(json);
	} else {
		return eval('(' + json + ')');
	}
}